/*
 * Decompiled with CFR 0.152.
 */
package sms.util;

import emisor.schema.ObjectFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import sms.soap.Documento;
import sms.util.LogDTO;

public class Util {
    private static String PATH;
    private static String SEPARADOR;
    private static String nivel;
    private static String mod;
    private static String corr;
    private static String serviceName;
    private static String uri;
    private static char[] conv;

    static {
        nivel = "1";
        mod = "0";
        corr = "19";
        serviceName = "/SmdtWS/SmdtService.jws";
        uri = "urn:aduana:Documentos";
        conv = new char[]{'-', '/', '*', '+', '?', ':', '\\', '=', ',', ';', '\'', '\"', '[', ']', '%', '&', '_'};
    }

    public static String getPATH() {
        try {
            PATH = new File(".").getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return PATH;
    }

    public static String getSEPARADOR() {
        try {
            new File(".");
            SEPARADOR = String.valueOf(File.separatorChar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(SEPARADOR);
    }

    public static String getCorr() {
        return corr;
    }

    public static String getMod() {
        return mod;
    }

    public static String getNivel() {
        return nivel;
    }

    public static String getServiceName() {
        return serviceName;
    }

    public static String getUri() {
        return uri;
    }

    public static String[] getListado(String file) {
        Vector<String> vct = new Vector<String>();
        String[] listado = null;
        BufferedReader entrada = null;
        String texto = new String();
        String s = new String();
        try {
            FileReader fr = new FileReader(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "src" + Util.getSEPARADOR() + "maritimo" + Util.getSEPARADOR() + "util" + Util.getSEPARADOR() + "properties" + Util.getSEPARADOR() + file);
            entrada = new BufferedReader(fr);
            while ((s = entrada.readLine()) != null) {
                texto = String.valueOf(texto) + s;
            }
            entrada.close();
            StringTokenizer st = new StringTokenizer(texto, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                vct.add(token);
            }
            listado = new String[vct.size()];
            int i = 0;
            while (i < vct.size()) {
                listado[i] = (String)vct.get(i);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listado;
    }

    public static String getActualTime(int min) {
        String minutos;
        Calendar cal = Calendar.getInstance();
        int hora = cal.get(11);
        int m = cal.get(12);
        if (min == 1) {
            if (m >= 5) {
                m -= 5;
            } else {
                --hora;
                switch (m) {
                    case 0: {
                        m = 55;
                        break;
                    }
                    case 1: {
                        m = 56;
                        break;
                    }
                    case 2: {
                        m = 57;
                        break;
                    }
                    case 3: {
                        m = 58;
                        break;
                    }
                    case 4: {
                        m = 59;
                    }
                }
            }
        }
        if ((minutos = String.valueOf(m)).length() == 1) {
            minutos = "0" + minutos;
        }
        String time = " " + hora + ":" + minutos;
        return time;
    }

    public static String getDate(int tpHora, Calendar c) {
        int d = c.get(5);
        int m = c.get(2) + 1;
        int anno = c.get(1);
        String dia = String.valueOf(d);
        String mes = String.valueOf(m);
        if (dia.length() == 1) {
            dia = "0" + dia;
        }
        if (mes.length() == 1) {
            mes = "0" + mes;
        }
        String fc = "";
        switch (tpHora) {
            case 1: {
                fc = String.valueOf(dia) + "-" + mes + "-" + anno + " " + Util.getActualTime(0);
                break;
            }
            case 2: {
                fc = String.valueOf(dia) + "-" + mes + "-" + anno + " " + "23:59";
                break;
            }
            case 3: {
                fc = String.valueOf(dia) + "-" + mes + "-" + anno;
                break;
            }
            case 4: {
                fc = String.valueOf(dia) + "-" + mes + "-" + anno + " " + Util.getActualTime(1);
            }
        }
        return fc;
    }

    public static void envioAnulacionGA(String nroRef, String idDocServ, String contenido) {
        BufferedWriter bw = null;
        PrintWriter salida = null;
        try {
            bw = new BufferedWriter(new FileWriter(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + "SNA-GA-2.0-" + nroRef + ".xml"));
            salida = new PrintWriter(bw);
            salida.println("<?xml version='1.0' encoding='ISO-8859-1' ?>");
            salida.println("<Documento tipo='GA' version='2.0'>");
            salida.println("<tipo-accion>N</tipo-accion>");
            salida.println("<id-documento-servidor>" + idDocServ + "</id-documento-servidor>");
            salida.println("<numero-referencia>" + nroRef + "</numero-referencia>");
            if (!contenido.equals("")) {
                salida.println("<contenido>" + contenido + "</contenido>");
            }
            salida.println("</Documento>");
            salida.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void envioAnulacionMA(String nroRef, String idDocServ, String contenido) {
        BufferedWriter bw = null;
        PrintWriter salida = null;
        try {
            bw = new BufferedWriter(new FileWriter(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + "SNA-MFTOA-2.0-" + nroRef + ".xml"));
            salida = new PrintWriter(bw);
            salida.println("<?xml version='1.0' encoding='ISO-8859-1' ?>");
            salida.println("<Documento tipo='MFTOA' version='2.0'>");
            salida.println("<tipo-accion>N</tipo-accion>");
            salida.println("<id-documento-servidor>" + idDocServ + "</id-documento-servidor>");
            salida.println("<numero-referencia>" + nroRef + "</numero-referencia>");
            if (!contenido.equals("")) {
                salida.println("<contenido>" + contenido + "</contenido>");
            }
            salida.println("</Documento>");
            salida.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void newFile(String fileOriginal, String fileCopia) {
        BufferedReader entrada = null;
        String texto = new String();
        String s = new String();
        BufferedWriter bw = null;
        PrintWriter salida = null;
        try {
            FileReader fr = new FileReader(fileOriginal);
            entrada = new BufferedReader(fr);
            while ((s = entrada.readLine()) != null) {
                texto = String.valueOf(texto) + s + "\n";
            }
            entrada.close();
            StringTokenizer st = new StringTokenizer(texto, "\n");
            bw = new BufferedWriter(new FileWriter(fileCopia));
            salida = new PrintWriter(bw);
            while (st.hasMoreTokens()) {
                salida.println(st.nextToken());
            }
            salida.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println("Archivo no encontrado: " + fnfex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteFile(String file) {
        try {
            if (new File(file).exists()) {
                System.gc();
                new File(file).delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cleanDir(String nmDir) {
        try {
            File dir = new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + nmDir);
            File[] files = dir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    System.gc();
                    files[i].delete();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cleanAndDeleteDir(String nmDir) {
        try {
            File dir = new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + nmDir);
            File[] files = dir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    System.gc();
                    files[i].delete();
                    ++i;
                }
            }
            dir.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRutValido(String tpId) {
        while (tpId.indexOf(".") != -1 || tpId.indexOf("-") != -1) {
            String fin;
            String inicio;
            if (tpId.indexOf(".") != -1) {
                inicio = tpId.substring(0, tpId.indexOf("."));
                fin = tpId.substring(tpId.indexOf(".") + 1, tpId.length());
                tpId = String.valueOf(inicio) + fin;
            }
            if (tpId.indexOf("-") == -1) continue;
            inicio = tpId.substring(0, tpId.indexOf("-"));
            fin = tpId.substring(tpId.indexOf("-") + 1, tpId.length());
            tpId = String.valueOf(inicio) + fin;
        }
        String rut = new String();
        String dv = new String();
        int largo = tpId.length();
        if (largo < 2) {
            return false;
        }
        rut = largo > 2 ? tpId.substring(0, largo - 1) : String.valueOf(tpId.charAt(0));
        dv = String.valueOf(tpId.charAt(largo - 1));
        if (Util.validaDV(dv)) {
            String dvr = "0";
            int suma = 0;
            int mul = 2;
            int i = rut.length() - 1;
            while (i >= 0) {
                suma += Integer.parseInt(String.valueOf(rut.charAt(i))) * mul;
                mul = mul == 7 ? 2 : ++mul;
                --i;
            }
            int res = suma % 11;
            if (res == 1) {
                dvr = "k";
            } else if (res == 0) {
                dvr = "0";
            } else {
                int dvi = 11 - res;
                dvr = String.valueOf(dvi);
            }
            return dvr.equals(dv.toLowerCase());
        }
        return false;
    }

    private static boolean validaDV(String dv) {
        return dv.equals("0") || dv.equals("1") || dv.equals("2") || dv.equals("3") || dv.equals("4") || dv.equals("5") || dv.equals("6") || dv.equals("7") || dv.equals("8") || dv.equals("9") || dv.equals("k") || dv.equals("K");
    }

    public static String getNmDoc(String nrRef) {
        String nmGuia = "";
        nmGuia = nrRef.indexOf("-") != -1 ? String.valueOf(nrRef.substring(0, nrRef.indexOf("-"))) + ".(45)." + nrRef.substring(nrRef.indexOf("-") + 1, nrRef.length()) : nrRef;
        return nmGuia;
    }

    public static String transformaNumeroRefANombreArchivo(String numeroRef) {
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        while (i < numeroRef.length()) {
            char c = numeroRef.charAt(i);
            boolean convertido = false;
            int j = 0;
            while (j < conv.length) {
                if (c != '<' && c != '>') {
                    if (c == conv[j]) {
                        convertido = true;
                        String conversion = ".(" + c + ").";
                        ret.append(conversion);
                        break;
                    }
                } else {
                    return null;
                }
                ++j;
            }
            if (!convertido) {
                ret.append(c);
            }
            ++i;
        }
        return ret.toString();
    }

    public static String transformaNombreArchivoANumeroRef(String nombreArchivo) {
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        int p = nombreArchivo.indexOf(".(");
        while (p >= 0) {
            ret.append(nombreArchivo.substring(i, p));
            int p2 = nombreArchivo.indexOf(").", p);
            if (p2 > 0) {
                i = p2 + 2;
                String stCod = nombreArchivo.substring(p + 2, p2);
                try {
                    int cod = Integer.valueOf(stCod);
                    char c = (char)cod;
                    ret.append(c);
                }
                catch (Exception E) {
                    E.printStackTrace();
                    return "NOMBRE DE ARCHIVO INVALIDO";
                }
            }
            p = nombreArchivo.indexOf(".(", i);
        }
        ret.append(nombreArchivo.substring(i));
        return ret.toString();
    }

    public static String transformaACaracter(int num) {
        Character caracter = null;
        int j = 0;
        while (j < conv.length) {
            if (num == conv[j]) {
                caracter = new Character(conv[j]);
            }
            ++j;
        }
        return caracter.toString();
    }

    public static void setNuevoTag(String oldTag, String newTag, String file) {
        BufferedReader entrada = null;
        BufferedWriter bw = null;
        PrintWriter newFile = null;
        String texto = new String();
        String s = new String();
        try {
            FileReader fr = new FileReader(file);
            entrada = new BufferedReader(fr);
            while ((s = entrada.readLine()) != null) {
                texto = String.valueOf(texto) + s + "\n";
            }
            entrada.close();
            StringTokenizer st = new StringTokenizer(texto, "\n");
            bw = new BufferedWriter(new FileWriter(file));
            newFile = new PrintWriter(bw);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.indexOf("<" + oldTag + ">") != -1) {
                    token = String.valueOf(token.substring(0, token.indexOf("<"))) + "<" + newTag + ">";
                }
                if (token.indexOf("</" + oldTag + ">") != -1) {
                    token = String.valueOf(token.substring(0, token.indexOf("<"))) + "</" + newTag + ">";
                }
                newFile.println(token);
            }
            newFile.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println("Archivo no encontrado: " + fnfex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void reBuildFile(String file) {
        BufferedReader entrada = null;
        BufferedWriter bw = null;
        PrintWriter newFile = null;
        String texto = new String();
        String s = new String();
        try {
            FileReader fr = new FileReader(file);
            entrada = new BufferedReader(fr);
            while ((s = entrada.readLine()) != null) {
                texto = String.valueOf(texto) + s + "\n";
            }
            entrada.close();
            StringTokenizer st = new StringTokenizer(texto, "\n");
            bw = new BufferedWriter(new FileWriter(file));
            newFile = new PrintWriter(bw);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                newFile.println(token);
            }
            newFile.flush();
            newFile.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println("Archivo no encontrado: " + fnfex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getSelected(String selected, String nmPropertie) {
        int select = 0;
        BufferedReader entrada = null;
        String texto = new String();
        String s = new String();
        try {
            FileReader fr = new FileReader(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "src" + Util.getSEPARADOR() + "maritimo" + Util.getSEPARADOR() + "util" + Util.getSEPARADOR() + "properties" + Util.getSEPARADOR() + nmPropertie);
            entrada = new BufferedReader(fr);
            while ((s = entrada.readLine()) != null) {
                texto = String.valueOf(texto) + s + ";";
            }
            entrada.close();
            StringTokenizer st = new StringTokenizer(texto, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equals(selected)) {
                    ++select;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return select;
    }

    public static void marcaDocEnviado(String file, String marca) {
        BufferedReader entrada = null;
        BufferedWriter bw = null;
        PrintWriter newFile = null;
        String texto = new String();
        String s = new String();
        try {
            FileReader fr = new FileReader(file);
            entrada = new BufferedReader(fr);
            while ((s = entrada.readLine()) != null) {
                texto = String.valueOf(texto) + s + "\n";
            }
            entrada.close();
            StringTokenizer st = new StringTokenizer(texto, "\n");
            bw = new BufferedWriter(new FileWriter(file));
            newFile = new PrintWriter(bw);
            int cont = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                newFile.println(token);
                if (cont == 3) {
                    newFile.println(marca);
                }
                ++cont;
            }
            newFile.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println("Archivo no encontrado: " + fnfex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean deleteMarcaDocEnviado(String file, String marca) {
        BufferedReader entrada = null;
        BufferedWriter bw = null;
        PrintWriter newFile = null;
        String texto = new String();
        String s = new String();
        boolean conMarca = false;
        try {
            FileReader fr = new FileReader(file);
            entrada = new BufferedReader(fr);
            while ((s = entrada.readLine()) != null) {
                texto = String.valueOf(texto) + s + ";";
            }
            entrada.close();
            StringTokenizer st = new StringTokenizer(texto, ";");
            bw = new BufferedWriter(new FileWriter(file));
            newFile = new PrintWriter(bw);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.indexOf(marca) == -1) {
                    newFile.println(token);
                    continue;
                }
                conMarca = true;
            }
            newFile.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println("Archivo no encontrado: " + fnfex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return conMarca;
    }

    public static void creaLog(String msg) {
        try {
            File logFile;
            SimpleDateFormat df = new SimpleDateFormat("ddMMyyyy");
            String date = df.format(new Date());
            File logFolder = new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "log");
            if (!logFolder.exists()) {
                logFolder.mkdirs();
            }
            if (!(logFile = new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "log" + Util.getSEPARADOR() + "smsLog-" + date + ".log")).exists()) {
                logFile.createNewFile();
            }
            FileWriter out = new FileWriter(logFile.getCanonicalPath(), true);
            out.write(String.valueOf(msg) + "\n");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void creaLog(LogDTO log) {
        try {
            File logFile;
            SimpleDateFormat df = new SimpleDateFormat("ddMMyyyy");
            String date = df.format(new Date());
            File logFolder = new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "log");
            if (!logFolder.exists()) {
                logFolder.mkdirs();
            }
            if (!(logFile = new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "log" + Util.getSEPARADOR() + "dataLog-" + date + ".txt")).exists()) {
                logFile.createNewFile();
            }
            FileWriter out = new FileWriter(logFile.getCanonicalPath(), true);
            out.write(String.valueOf(log.getNroReferencia()) + ";" + log.getFhInicio() + ";" + log.getFhTermino() + ";" + log.getTpoProceso() + ";" + log.getTotMemoria() + ";" + log.getMemInicio() + ";" + log.getMemTermino() + ";" + log.getMemUsada() + ";" + log.getTpDocumento() + ";" + log.getTpRutina() + ";" + log.getTpAccion() + ";\n");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMemoria() {
        long freeMem = Runtime.getRuntime().freeMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        double pctFree = (double)freeMem / (double)totalMem;
        long pFree = (int)(100.0 * pctFree);
        return "DATA: " + pFree + "% free , total = " + totalMem + " , free = " + freeMem;
    }

    public static String creaNmArchivo(Documento documento) {
        StringTokenizer nmArchivo = new StringTokenizer(documento.getFileSrc(), "-");
        String server = nmArchivo.nextToken();
        String tpDoc = nmArchivo.nextToken();
        String version = nmArchivo.nextToken();
        String nrRef = new String();
        try {
            String nmFile = documento.getFileSrc();
            int i = 0;
            while (i < 3) {
                nmFile = nmFile.substring(nmFile.indexOf("-") + 1);
                ++i;
            }
            nrRef = nmFile.substring(0, nmFile.lastIndexOf("."));
            nrRef = Util.transformaNumeroRefANombreArchivo(nrRef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(server) + "-" + tpDoc + "-" + version + "-" + nrRef + ".xml";
    }

    public static void creaEmisorConf(Vector emisorData) {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            emisor.schema.Documento documento = objFactory.createDocumento();
            if (!emisorData.isEmpty() && emisorData.size() > 1) {
                Hashtable ht = (Hashtable)emisorData.get(1);
                documento.setCodPais((String)ht.get("cdPais"));
                if (ht.get("direccion") != null && !ht.get("direccion").equals("")) {
                    documento.setDireccion((String)ht.get("direccion"));
                }
                documento.setNacionalidad((String)ht.get("nacionalidad"));
                documento.setNombre((String)ht.get("nombre"));
                documento.setTipo("SMS");
                documento.setTipoId((String)ht.get("tpId"));
                documento.setValorId((String)ht.get("valorId"));
                documento.setVersion("1.0");
            } else {
                documento.setTipo("SMS");
                documento.setObservacion("NO_DATA");
                documento.setVersion("1.0");
            }
            JAXBContext jc = JAXBContext.newInstance("emisor.schema");
            Validator v = jc.createValidator();
            boolean valid = v.validateRoot(documento);
            if (valid) {
                Marshaller m = jc.createMarshaller();
                m.setProperty("jaxb.encoding", "ISO-8859-1");
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                String xml = String.valueOf(Util.getPATH()) + "/conf/emisor.xml";
                m.marshal((Object)documento, new FileOutputStream(xml));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

