/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import mftoc.schema.Documento;
import mftoc.schema.DocumentoType;
import mftoc.schema.ObjectFactory;
import sms.soap.Start;
import sms.util.Util;
import sms.validador.CourierANUv10;

public class MFTOCv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public MFTOCv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento documento = objFactory.createDocumento();
            documentWrapper dw = new documentWrapper(new File(this.file));
            if (!dw.getAttribute("tipo-accion").equals("N")) {
                if (dw.getDocType().equals("MFTOC")) {
                    documento.setTipo(dw.getDocType());
                }
                if (dw.getVersion().equals("1.0")) {
                    documento.setVersion(dw.getVersion());
                }
                if (dw.existAttribute("login") && !dw.getAttribute("login").equals("")) {
                    documento.setLogin(dw.getAttribute("login").trim());
                }
                if (!dw.existAttribute("tipo-accion")) {
                    documento.setTipoAccion("I");
                } else {
                    documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
                }
                if (dw.existAttribute("numero-referencia") && !dw.getAttribute("numero-referencia").equals("")) {
                    documento.setNumeroReferencia(dw.getAttribute("numero-referencia").trim());
                }
                if (dw.existAttribute("tipo-manifiesto") && !dw.getAttribute("tipo-manifiesto").equals("")) {
                    documento.setTipoManifiesto(dw.getAttribute("tipo-manifiesto").trim());
                }
                this.cargaOpTransporte(documento, dw);
                this.cargaFechas(documento, dw);
                this.cargaLocaciones(documento, dw);
                this.cargaParticipaciones(documento, dw);
                this.cargaReferencias(documento, dw);
                this.cargaObservaciones(documento, dw);
                JAXBContext jc = JAXBContext.newInstance("mftoc.schema");
                Validator v = jc.createValidator();
                this.valid = v.validateRoot(documento);
                if (this.valid) {
                    Marshaller m = jc.createMarshaller();
                    m.setProperty("jaxb.encoding", "ISO-8859-1");
                    m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                        new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                    }
                    String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                    m.marshal((Object)documento, new FileOutputStream(xml));
                }
            } else {
                this.valid = new CourierANUv10(this.file, this.doc).isValid();
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: MFTOC con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void cargaOpTransporte(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("OpTransporte")) {
                DocumentoType.OpTransporteType OpTransTp = objFactory.createDocumentoTypeOpTransporteType();
                DocumentoType.OpTransporteType.OptransporteType opTransTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteType();
                AttrContainer atc = dw.getContainer("OpTransporte");
                Enumeration enm = atc.getItems();
                ContainerItem ci = (ContainerItem)enm.nextElement();
                Properties prop = ci.getAttributes();
                if (prop.containsKey("numero-viaje") && !prop.get("numero-viaje").equals("")) {
                    opTransTp.setNumeroViaje(String.valueOf(prop.get("numero-viaje")).trim());
                }
                if (prop.containsKey("via-transporte") && !prop.get("via-transporte").equals("")) {
                    opTransTp.setViaTransporte(String.valueOf(prop.get("via-transporte")).trim());
                }
                OpTransTp.setOptransporte(opTransTp);
                documento.setOpTransporte(OpTransTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaFechas(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Fechas")) {
                DocumentoType.FechasType FcTp = objFactory.createDocumentoTypeFechasType();
                AttrContainer atc = dw.getContainer("Fechas");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.FechasType.FechaType fcTp = objFactory.createDocumentoTypeFechasTypeFechaType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        fcTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor") && !prop.get("valor").equals("")) {
                        fcTp.setValor(String.valueOf(prop.get("valor")).trim());
                    }
                    FcTp.getFecha().add(fcTp);
                }
                documento.setFechas(FcTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaLocaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Locaciones")) {
                DocumentoType.LocacionesType LocTp = objFactory.createDocumentoTypeLocacionesType();
                AttrContainer atc = dw.getContainer("Locaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.LocacionesType.LocacionType locTp = objFactory.createDocumentoTypeLocacionesTypeLocacionType();
                    if (prop.containsKey("codigo") && !prop.get("codigo").equals("")) {
                        locTp.setCodigo(String.valueOf(prop.get("codigo")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        locTp.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        locTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    LocTp.getLocacion().add(locTp);
                }
                documento.setLocaciones(LocTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaParticipaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType PartTp = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = dw.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType partTp = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("codigo-pais") && !prop.get("codigo-pais").equals("")) {
                        partTp.setCodigoPais(String.valueOf(prop.get("codigo-pais")).trim());
                    }
                    if (prop.containsKey("direccion") && !prop.get("direccion").equals("")) {
                        partTp.setDireccion(String.valueOf(prop.get("direccion")).trim());
                    }
                    if (prop.containsKey("nacion-id") && !prop.get("nacion-id").equals("")) {
                        partTp.setNacionId(String.valueOf(prop.get("nacion-id")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        partTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("nombres") && !prop.get("nombres").equals("")) {
                        partTp.setNombres(String.valueOf(prop.get("nombres")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        partTp.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        partTp.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    PartTp.getParticipacion().add(partTp);
                }
                documento.setParticipaciones(PartTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaReferencias(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Referencias")) {
                DocumentoType.ReferenciasType RefTp = objFactory.createDocumentoTypeReferenciasType();
                AttrContainer atc = dw.getContainer("Referencias");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ReferenciasType.ReferenciaType refTp = objFactory.createDocumentoTypeReferenciasTypeReferenciaType();
                    if (prop.containsKey("emisor") && !prop.get("emisor").equals("")) {
                        refTp.setEmisor(String.valueOf(prop.get("emisor")).trim());
                    }
                    if (prop.containsKey("fecha") && !prop.get("fecha").equals("")) {
                        refTp.setFecha(String.valueOf(prop.get("fecha")).trim());
                    }
                    if (prop.containsKey("nac-id-emisor") && !prop.get("nac-id-emisor").equals("")) {
                        refTp.setNacIdEmisor(String.valueOf(prop.get("nac-id-emisor")).trim());
                    }
                    if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                        refTp.setNumero(String.valueOf(prop.get("numero")).trim());
                    }
                    if (prop.containsKey("observaciones") && !prop.get("observaciones").equals("")) {
                        refTp.setObservaciones(String.valueOf(prop.get("observaciones")).trim());
                    }
                    if (prop.containsKey("tipo-documento") && !prop.get("tipo-documento").equals("")) {
                        refTp.setTipoDocumento(String.valueOf(prop.get("tipo-documento")).trim());
                    }
                    if (prop.containsKey("tipo-id-emisor") && !prop.get("tipo-id-emisor").equals("")) {
                        refTp.setTipoIdEmisor(String.valueOf(prop.get("tipo-id-emisor")).trim());
                    }
                    if (prop.containsKey("tipo-referencia") && !prop.get("tipo-referencia").equals("")) {
                        refTp.setTipoReferencia(String.valueOf(prop.get("tipo-referencia")).trim());
                    }
                    if (prop.containsKey("valor-id-emisor") && !prop.get("valor-id-emisor").equals("")) {
                        refTp.setValorIdEmisor(String.valueOf(prop.get("valor-id-emisor")).trim());
                    }
                    RefTp.getReferencia().add(refTp);
                }
                documento.setReferencias(RefTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaObservaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            DocumentoType.ObservacionesType ObTp = objFactory.createDocumentoTypeObservacionesType();
            if (dw.existContainer("Observaciones")) {
                AttrContainer atc = dw.getContainer("Observaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ObservacionesType.ObservacionType obTp = objFactory.createDocumentoTypeObservacionesTypeObservacionType();
                    if (prop.containsKey("contenido") && !prop.get("contenido").equals("")) {
                        obTp.setContenido(String.valueOf(prop.get("contenido")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        obTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    ObTp.getObservacion().add(obTp);
                }
                documento.setObservaciones(ObTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

