/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import org.apache.xalan.transformer.KeyIterator;
import org.apache.xalan.transformer.KeyWalker;
import org.apache.xml.utils.QName;
import org.apache.xpath.NodeSet;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class KeyRefIterator
extends LocPathIterator {
    private QName m_name;
    private String m_lookupKey;
    private KeyIterator m_ki;

    public KeyRefIterator(String ref, KeyIterator ki) {
        super(ki.getPrefixResolver());
        this.setShouldCacheNodes(true);
        this.m_ki = ki;
        this.m_name = ki.getName();
        this.m_lookupKey = ref;
        this.m_execContext = ki.getXPathContext();
        this.m_dhelper = ki.getDOMHelper();
    }

    public void addNode(Node node) {
        NodeSet m_cachedNodes = this.getCachedNodes();
        if (m_cachedNodes != null && !m_cachedNodes.contains(node)) {
            m_cachedNodes.addElement(node);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        KeyRefIterator clone = (KeyRefIterator)super.clone();
        return clone;
    }

    public QName getName() {
        return this.m_name;
    }

    public Node nextNode() throws DOMException {
        if (this.m_foundLast) {
            return null;
        }
        NodeSet m_cachedNodes = this.getCachedNodes();
        if (m_cachedNodes != null && this.m_next < m_cachedNodes.size()) {
            Node next = m_cachedNodes.elementAt(this.m_next);
            this.setCurrentPos(++this.m_next);
            this.m_lastFetched = next;
            return next;
        }
        Node next = null;
        if (this.m_ki.getLookForMoreNodes()) {
            ((KeyWalker)this.m_ki.getFirstWalker()).m_lookupKey = this.m_lookupKey;
            next = this.m_ki.nextNode();
        }
        if (next != null) {
            this.m_lastFetched = next;
            this.setCurrentPos(++this.m_next);
            return next;
        }
        this.m_foundLast = true;
        this.m_lastFetched = null;
        return null;
    }

    public void reset() {
        super.reset();
        this.setCurrentPos(0);
    }
}

