/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.iso_relax.ant.ErrorHandlerImpl;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.SAXException;

public class JARVTask
extends Task {
    private File schemaFile;
    private String schemaLanguage;
    private File xmlFile;
    private List xmlFiles = new ArrayList();

    public void execute() throws BuildException {
        try {
            Verifier verifier;
            VerifierFactory factory;
            if (this.schemaLanguage == null) {
                throw new BuildException("schema language needs to be specified through the schemaLanguage attribute", this.location);
            }
            if (this.schemaFile == null) {
                throw new BuildException("schema file needs to be specified through the schema attribute", this.location);
            }
            try {
                factory = VerifierFactory.newInstance(this.schemaLanguage, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (VerifierConfigurationException e) {
                throw new BuildException("unable to load a validator for the schema language: " + this.schemaLanguage, (Throwable)e, this.location);
            }
            ErrorHandlerImpl errorHandler = new ErrorHandlerImpl(this);
            try {
                verifier = factory.newVerifier(this.schemaFile);
                verifier.setErrorHandler(errorHandler);
            }
            catch (VerifierConfigurationException e) {
                throw new BuildException("failed to compile the schema:" + e.getMessage(), (Throwable)e, this.location);
            }
            boolean noError = true;
            if (this.xmlFile != null) {
                this.log("validating " + this.xmlFile, 2);
                noError |= verifier.verify(this.xmlFile);
            }
            int i = 0;
            while (i < this.xmlFiles.size()) {
                FileSet fs = (FileSet)this.xmlFiles.get(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                File dir = fs.getDir(this.project);
                String[] src = ds.getIncludedFiles();
                int j = 0;
                while (j < src.length) {
                    File f = new File(dir, src[j]);
                    this.log("validating " + f, 2);
                    noError |= verifier.verify(f);
                    ++j;
                }
                ++i;
            }
            if (errorHandler.hadError) {
                noError = false;
            }
            if (!noError) {
                throw new BuildException("validation error. the error message should have been provided");
            }
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e, this.location);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }

    public void setFile(File file) {
        this.xmlFile = file;
    }

    public void setSchema(String schemaFilename) {
        this.schemaFile = this.project.resolveFile(schemaFilename);
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public void addFileset(FileSet fs) {
        this.xmlFiles.add(fs);
    }
}

